/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.utils.ZipUtils;
import org.sonarsource.sonarlint.core.plugin.ExplodedPlugin;
import org.sonarsource.sonarlint.core.plugin.PluginInfo;
import org.sonarsource.sonarlint.core.plugin.PluginJarExploder;
import org.sonarsource.sonarlint.core.plugin.cache.PluginCache;

@BatchSide
public class DefaultPluginJarExploder
extends PluginJarExploder {
    private final PluginCache fileCache;

    public DefaultPluginJarExploder(PluginCache fileCache) {
        this.fileCache = fileCache;
    }

    @Override
    public ExplodedPlugin explode(PluginInfo info) {
        try {
            File dir = this.unzipFile(info.getNonNullJarFile());
            return this.explodeFromUnzippedDir(info.getKey(), info.getNonNullJarFile(), dir);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to open plugin [%s]: %s", info.getKey(), info.getNonNullJarFile().getAbsolutePath()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File unzipFile(File cachedFile) throws IOException {
        String filename = cachedFile.getName();
        File destDir = new File(cachedFile.getParentFile(), filename + "_unzip");
        File lockFile = new File(cachedFile.getParentFile(), filename + "_unzip.lock");
        if (!destDir.exists()) {
            FileOutputStream out = new FileOutputStream(lockFile);
            try {
                FileLock lock = out.getChannel().lock();
                try {
                    if (!destDir.exists()) {
                        Path tempDir = this.fileCache.createTempDir();
                        ZipUtils.unzip(cachedFile, tempDir.toFile(), this.newLibFilter());
                        FileUtils.moveDirectory(tempDir.toFile(), destDir);
                    }
                }
                finally {
                    lock.release();
                }
            }
            finally {
                out.close();
                FileUtils.deleteQuietly(lockFile);
            }
        }
        return destDir;
    }
}

